package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{IndexName, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContributorInsightsSummary(
    tableName: Optional[TableName] = Optional.Absent,
    indexName: Optional[IndexName] = Optional.Absent,
    contributorInsightsStatus: Optional[
      zio.aws.dynamodb.model.ContributorInsightsStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary = {
    import ContributorInsightsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(contributorInsightsStatus.map(value => value.unwrap))(
        _.contributorInsightsStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly =
    zio.aws.dynamodb.model.ContributorInsightsSummary.wrap(buildAwsValue())
}
object ContributorInsightsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ContributorInsightsSummary =
      zio.aws.dynamodb.model.ContributorInsightsSummary(
        tableName.map(value => value),
        indexName.map(value => value),
        contributorInsightsStatus.map(value => value)
      )
    def tableName: Optional[TableName]
    def indexName: Optional[IndexName]
    def contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getContributorInsightsStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ContributorInsightsStatus] =
      AwsError.unwrapOptionField(
        "contributorInsightsStatus",
        contributorInsightsStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary
  ) extends zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val contributorInsightsStatus
        : Optional[zio.aws.dynamodb.model.ContributorInsightsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contributorInsightsStatus())
        .map(value =>
          zio.aws.dynamodb.model.ContributorInsightsStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary
  ): zio.aws.dynamodb.model.ContributorInsightsSummary.ReadOnly = new Wrapper(
    impl
  )
}
