package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGlobalTableResponse(
    globalTableDescription: Optional[
      zio.aws.dynamodb.model.GlobalTableDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse = {
    import CreateGlobalTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse
      .builder()
      .optionallyWith(
        globalTableDescription.map(value => value.buildAwsValue())
      )(_.globalTableDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly =
    zio.aws.dynamodb.model.CreateGlobalTableResponse.wrap(buildAwsValue())
}
object CreateGlobalTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.CreateGlobalTableResponse =
      zio.aws.dynamodb.model.CreateGlobalTableResponse(
        globalTableDescription.map(value => value.asEditable)
      )
    def globalTableDescription
        : Optional[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly]
    def getGlobalTableDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalTableDescription",
      globalTableDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse
  ) extends zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly {
    override val globalTableDescription
        : Optional[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalTableDescription())
        .map(value => zio.aws.dynamodb.model.GlobalTableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse
  ): zio.aws.dynamodb.model.CreateGlobalTableResponse.ReadOnly = new Wrapper(
    impl
  )
}
