package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.RegionName
import scala.jdk.CollectionConverters.*
final case class DeleteReplicaAction(regionName: RegionName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction = {
    import DeleteReplicaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly =
    zio.aws.dynamodb.model.DeleteReplicaAction.wrap(buildAwsValue())
}
object DeleteReplicaAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DeleteReplicaAction =
      zio.aws.dynamodb.model.DeleteReplicaAction(regionName)
    def regionName: RegionName
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction
  ) extends zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DeleteReplicaAction
  ): zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly = new Wrapper(impl)
}
