package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisableKinesisStreamingDestinationResponse(
    tableName: Optional[TableName] = Optional.Absent,
    streamArn: Optional[StreamArn] = Optional.Absent,
    destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse = {
    import DisableKinesisStreamingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(destinationStatus.map(value => value.unwrap))(
        _.destinationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly =
    zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse
      .wrap(buildAwsValue())
}
object DisableKinesisStreamingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse =
      zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse(
        tableName.map(value => value),
        streamArn.map(value => value),
        destinationStatus.map(value => value)
      )
    def tableName: Optional[TableName]
    def streamArn: Optional[StreamArn]
    def destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDestinationStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DestinationStatus] =
      AwsError.unwrapOptionField("destinationStatus", destinationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse
  ) extends zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val destinationStatus
        : Optional[zio.aws.dynamodb.model.DestinationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationStatus())
        .map(value => zio.aws.dynamodb.model.DestinationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse
  ): zio.aws.dynamodb.model.DisableKinesisStreamingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
