package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{StreamArn, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnableKinesisStreamingDestinationResponse(
    tableName: Optional[TableName] = Optional.Absent,
    streamArn: Optional[StreamArn] = Optional.Absent,
    destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse = {
    import EnableKinesisStreamingDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(destinationStatus.map(value => value.unwrap))(
        _.destinationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly =
    zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse
      .wrap(buildAwsValue())
}
object EnableKinesisStreamingDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse =
      zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse(
        tableName.map(value => value),
        streamArn.map(value => value),
        destinationStatus.map(value => value)
      )
    def tableName: Optional[TableName]
    def streamArn: Optional[StreamArn]
    def destinationStatus: Optional[zio.aws.dynamodb.model.DestinationStatus]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getDestinationStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.DestinationStatus] =
      AwsError.unwrapOptionField("destinationStatus", destinationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ) extends zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.dynamodb.model.primitives.StreamArn(value))
    override val destinationStatus
        : Optional[zio.aws.dynamodb.model.DestinationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationStatus())
        .map(value => zio.aws.dynamodb.model.DestinationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse
  ): zio.aws.dynamodb.model.EnableKinesisStreamingDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
