package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  ExportTime,
  ExportStartTime,
  S3Prefix,
  S3BucketOwner,
  S3SseKmsKeyId,
  ItemCount,
  ExportManifest,
  ExportEndTime,
  ExportArn,
  TableArn,
  ClientToken,
  BilledSizeBytes,
  FailureCode,
  FailureMessage,
  S3Bucket,
  TableId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ExportDescription(
    exportArn: Optional[ExportArn] = Optional.Absent,
    exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus] =
      Optional.Absent,
    startTime: Optional[ExportStartTime] = Optional.Absent,
    endTime: Optional[ExportEndTime] = Optional.Absent,
    exportManifest: Optional[ExportManifest] = Optional.Absent,
    tableArn: Optional[TableArn] = Optional.Absent,
    tableId: Optional[TableId] = Optional.Absent,
    exportTime: Optional[ExportTime] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3BucketOwner: Optional[S3BucketOwner] = Optional.Absent,
    s3Prefix: Optional[S3Prefix] = Optional.Absent,
    s3SseAlgorithm: Optional[zio.aws.dynamodb.model.S3SseAlgorithm] =
      Optional.Absent,
    s3SseKmsKeyId: Optional[S3SseKmsKeyId] = Optional.Absent,
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureMessage: Optional[FailureMessage] = Optional.Absent,
    exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat] =
      Optional.Absent,
    billedSizeBytes: Optional[BilledSizeBytes] = Optional.Absent,
    itemCount: Optional[ItemCount] = Optional.Absent,
    exportType: Optional[zio.aws.dynamodb.model.ExportType] = Optional.Absent,
    incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportDescription = {
    import ExportDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportDescription
      .builder()
      .optionallyWith(
        exportArn.map(value => ExportArn.unwrap(value): java.lang.String)
      )(_.exportArn)
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .optionallyWith(
        startTime.map(value => ExportStartTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => ExportEndTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        exportManifest.map(value =>
          ExportManifest.unwrap(value): java.lang.String
        )
      )(_.exportManifest)
      .optionallyWith(
        tableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.tableArn)
      .optionallyWith(
        tableId.map(value => TableId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        exportTime.map(value => ExportTime.unwrap(value): Instant)
      )(_.exportTime)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3BucketOwner.map(value =>
          S3BucketOwner.unwrap(value): java.lang.String
        )
      )(_.s3BucketOwner)
      .optionallyWith(
        s3Prefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .optionallyWith(s3SseAlgorithm.map(value => value.unwrap))(
        _.s3SseAlgorithm
      )
      .optionallyWith(
        s3SseKmsKeyId.map(value =>
          S3SseKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.s3SseKmsKeyId)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value =>
          FailureMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(exportFormat.map(value => value.unwrap))(_.exportFormat)
      .optionallyWith(
        billedSizeBytes.map(value =>
          BilledSizeBytes.unwrap(value): java.lang.Long
        )
      )(_.billedSizeBytes)
      .optionallyWith(
        itemCount.map(value => ItemCount.unwrap(value): java.lang.Long)
      )(_.itemCount)
      .optionallyWith(exportType.map(value => value.unwrap))(_.exportType)
      .optionallyWith(
        incrementalExportSpecification.map(value => value.buildAwsValue())
      )(_.incrementalExportSpecification)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExportDescription.ReadOnly =
    zio.aws.dynamodb.model.ExportDescription.wrap(buildAwsValue())
}
object ExportDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportDescription =
      zio.aws.dynamodb.model.ExportDescription(
        exportArn.map(value => value),
        exportStatus.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        exportManifest.map(value => value),
        tableArn.map(value => value),
        tableId.map(value => value),
        exportTime.map(value => value),
        clientToken.map(value => value),
        s3Bucket.map(value => value),
        s3BucketOwner.map(value => value),
        s3Prefix.map(value => value),
        s3SseAlgorithm.map(value => value),
        s3SseKmsKeyId.map(value => value),
        failureCode.map(value => value),
        failureMessage.map(value => value),
        exportFormat.map(value => value),
        billedSizeBytes.map(value => value),
        itemCount.map(value => value),
        exportType.map(value => value),
        incrementalExportSpecification.map(value => value.asEditable)
      )
    def exportArn: Optional[ExportArn]
    def exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus]
    def startTime: Optional[ExportStartTime]
    def endTime: Optional[ExportEndTime]
    def exportManifest: Optional[ExportManifest]
    def tableArn: Optional[TableArn]
    def tableId: Optional[TableId]
    def exportTime: Optional[ExportTime]
    def clientToken: Optional[ClientToken]
    def s3Bucket: Optional[S3Bucket]
    def s3BucketOwner: Optional[S3BucketOwner]
    def s3Prefix: Optional[S3Prefix]
    def s3SseAlgorithm: Optional[zio.aws.dynamodb.model.S3SseAlgorithm]
    def s3SseKmsKeyId: Optional[S3SseKmsKeyId]
    def failureCode: Optional[FailureCode]
    def failureMessage: Optional[FailureMessage]
    def exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat]
    def billedSizeBytes: Optional[BilledSizeBytes]
    def itemCount: Optional[ItemCount]
    def exportType: Optional[zio.aws.dynamodb.model.ExportType]
    def incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ]
    def getExportArn: ZIO[Any, AwsError, ExportArn] =
      AwsError.unwrapOptionField("exportArn", exportArn)
    def getExportStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportStatus] =
      AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getStartTime: ZIO[Any, AwsError, ExportStartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, ExportEndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getExportManifest: ZIO[Any, AwsError, ExportManifest] =
      AwsError.unwrapOptionField("exportManifest", exportManifest)
    def getTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("tableArn", tableArn)
    def getTableId: ZIO[Any, AwsError, TableId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getExportTime: ZIO[Any, AwsError, ExportTime] =
      AwsError.unwrapOptionField("exportTime", exportTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, S3BucketOwner] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Prefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3SseAlgorithm
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3SseAlgorithm] =
      AwsError.unwrapOptionField("s3SseAlgorithm", s3SseAlgorithm)
    def getS3SseKmsKeyId: ZIO[Any, AwsError, S3SseKmsKeyId] =
      AwsError.unwrapOptionField("s3SseKmsKeyId", s3SseKmsKeyId)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, FailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getExportFormat
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportFormat] =
      AwsError.unwrapOptionField("exportFormat", exportFormat)
    def getBilledSizeBytes: ZIO[Any, AwsError, BilledSizeBytes] =
      AwsError.unwrapOptionField("billedSizeBytes", billedSizeBytes)
    def getItemCount: ZIO[Any, AwsError, ItemCount] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getExportType: ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportType] =
      AwsError.unwrapOptionField("exportType", exportType)
    def getIncrementalExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "incrementalExportSpecification",
      incrementalExportSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ) extends zio.aws.dynamodb.model.ExportDescription.ReadOnly {
    override val exportArn: Optional[ExportArn] = zio.aws.core.internal
      .optionalFromNullable(impl.exportArn())
      .map(value => zio.aws.dynamodb.model.primitives.ExportArn(value))
    override val exportStatus: Optional[zio.aws.dynamodb.model.ExportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportStatus())
        .map(value => zio.aws.dynamodb.model.ExportStatus.wrap(value))
    override val startTime: Optional[ExportStartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportStartTime(value))
    override val endTime: Optional[ExportEndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportEndTime(value))
    override val exportManifest: Optional[ExportManifest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportManifest())
        .map(value => zio.aws.dynamodb.model.primitives.ExportManifest(value))
    override val tableArn: Optional[TableArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val tableId: Optional[TableId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.dynamodb.model.primitives.TableId(value))
    override val exportTime: Optional[ExportTime] = zio.aws.core.internal
      .optionalFromNullable(impl.exportTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportTime(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.dynamodb.model.primitives.S3Bucket(value))
    override val s3BucketOwner: Optional[S3BucketOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.dynamodb.model.primitives.S3BucketOwner(value))
    override val s3Prefix: Optional[S3Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => zio.aws.dynamodb.model.primitives.S3Prefix(value))
    override val s3SseAlgorithm
        : Optional[zio.aws.dynamodb.model.S3SseAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3SseAlgorithm())
        .map(value => zio.aws.dynamodb.model.S3SseAlgorithm.wrap(value))
    override val s3SseKmsKeyId: Optional[S3SseKmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3SseKmsKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.S3SseKmsKeyId(value))
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.dynamodb.model.primitives.FailureCode(value))
    override val failureMessage: Optional[FailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value => zio.aws.dynamodb.model.primitives.FailureMessage(value))
    override val exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportFormat())
        .map(value => zio.aws.dynamodb.model.ExportFormat.wrap(value))
    override val billedSizeBytes: Optional[BilledSizeBytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billedSizeBytes())
        .map(value => zio.aws.dynamodb.model.primitives.BilledSizeBytes(value))
    override val itemCount: Optional[ItemCount] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => zio.aws.dynamodb.model.primitives.ItemCount(value))
    override val exportType: Optional[zio.aws.dynamodb.model.ExportType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportType())
        .map(value => zio.aws.dynamodb.model.ExportType.wrap(value))
    override val incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.incrementalExportSpecification())
      .map(value =>
        zio.aws.dynamodb.model.IncrementalExportSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportDescription
  ): zio.aws.dynamodb.model.ExportDescription.ReadOnly = new Wrapper(impl)
}
