package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  ExportTime,
  S3Prefix,
  S3BucketOwner,
  S3SseKmsKeyId,
  TableArn,
  ClientToken,
  S3Bucket
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ExportTableToPointInTimeRequest(
    tableArn: TableArn,
    exportTime: Optional[ExportTime] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    s3Bucket: S3Bucket,
    s3BucketOwner: Optional[S3BucketOwner] = Optional.Absent,
    s3Prefix: Optional[S3Prefix] = Optional.Absent,
    s3SseAlgorithm: Optional[zio.aws.dynamodb.model.S3SseAlgorithm] =
      Optional.Absent,
    s3SseKmsKeyId: Optional[S3SseKmsKeyId] = Optional.Absent,
    exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat] =
      Optional.Absent,
    exportType: Optional[zio.aws.dynamodb.model.ExportType] = Optional.Absent,
    incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest = {
    import ExportTableToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
      .builder()
      .tableArn(TableArn.unwrap(tableArn): java.lang.String)
      .optionallyWith(
        exportTime.map(value => ExportTime.unwrap(value): Instant)
      )(_.exportTime)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3BucketOwner.map(value =>
          S3BucketOwner.unwrap(value): java.lang.String
        )
      )(_.s3BucketOwner)
      .optionallyWith(
        s3Prefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .optionallyWith(s3SseAlgorithm.map(value => value.unwrap))(
        _.s3SseAlgorithm
      )
      .optionallyWith(
        s3SseKmsKeyId.map(value =>
          S3SseKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.s3SseKmsKeyId)
      .optionallyWith(exportFormat.map(value => value.unwrap))(_.exportFormat)
      .optionallyWith(exportType.map(value => value.unwrap))(_.exportType)
      .optionallyWith(
        incrementalExportSpecification.map(value => value.buildAwsValue())
      )(_.incrementalExportSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly =
    zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.wrap(buildAwsValue())
}
object ExportTableToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportTableToPointInTimeRequest =
      zio.aws.dynamodb.model.ExportTableToPointInTimeRequest(
        tableArn,
        exportTime.map(value => value),
        clientToken.map(value => value),
        s3Bucket,
        s3BucketOwner.map(value => value),
        s3Prefix.map(value => value),
        s3SseAlgorithm.map(value => value),
        s3SseKmsKeyId.map(value => value),
        exportFormat.map(value => value),
        exportType.map(value => value),
        incrementalExportSpecification.map(value => value.asEditable)
      )
    def tableArn: TableArn
    def exportTime: Optional[ExportTime]
    def clientToken: Optional[ClientToken]
    def s3Bucket: S3Bucket
    def s3BucketOwner: Optional[S3BucketOwner]
    def s3Prefix: Optional[S3Prefix]
    def s3SseAlgorithm: Optional[zio.aws.dynamodb.model.S3SseAlgorithm]
    def s3SseKmsKeyId: Optional[S3SseKmsKeyId]
    def exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat]
    def exportType: Optional[zio.aws.dynamodb.model.ExportType]
    def incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ]
    def getTableArn: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableArn)
    def getExportTime: ZIO[Any, AwsError, ExportTime] =
      AwsError.unwrapOptionField("exportTime", exportTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, S3BucketOwner] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Prefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3SseAlgorithm
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3SseAlgorithm] =
      AwsError.unwrapOptionField("s3SseAlgorithm", s3SseAlgorithm)
    def getS3SseKmsKeyId: ZIO[Any, AwsError, S3SseKmsKeyId] =
      AwsError.unwrapOptionField("s3SseKmsKeyId", s3SseKmsKeyId)
    def getExportFormat
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportFormat] =
      AwsError.unwrapOptionField("exportFormat", exportFormat)
    def getExportType: ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportType] =
      AwsError.unwrapOptionField("exportType", exportType)
    def getIncrementalExportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "incrementalExportSpecification",
      incrementalExportSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ) extends zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly {
    override val tableArn: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableArn())
    override val exportTime: Optional[ExportTime] = zio.aws.core.internal
      .optionalFromNullable(impl.exportTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportTime(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3Bucket: S3Bucket =
      zio.aws.dynamodb.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3BucketOwner: Optional[S3BucketOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketOwner())
      .map(value => zio.aws.dynamodb.model.primitives.S3BucketOwner(value))
    override val s3Prefix: Optional[S3Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => zio.aws.dynamodb.model.primitives.S3Prefix(value))
    override val s3SseAlgorithm
        : Optional[zio.aws.dynamodb.model.S3SseAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3SseAlgorithm())
        .map(value => zio.aws.dynamodb.model.S3SseAlgorithm.wrap(value))
    override val s3SseKmsKeyId: Optional[S3SseKmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.s3SseKmsKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.S3SseKmsKeyId(value))
    override val exportFormat: Optional[zio.aws.dynamodb.model.ExportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportFormat())
        .map(value => zio.aws.dynamodb.model.ExportFormat.wrap(value))
    override val exportType: Optional[zio.aws.dynamodb.model.ExportType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportType())
        .map(value => zio.aws.dynamodb.model.ExportType.wrap(value))
    override val incrementalExportSpecification: Optional[
      zio.aws.dynamodb.model.IncrementalExportSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.incrementalExportSpecification())
      .map(value =>
        zio.aws.dynamodb.model.IncrementalExportSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ): zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
