package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.BackupArn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBackupsResponse(
    backupSummaries: Optional[Iterable[zio.aws.dynamodb.model.BackupSummary]] =
      Optional.Absent,
    lastEvaluatedBackupArn: Optional[BackupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse = {
    import ListBackupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse
      .builder()
      .optionallyWith(
        backupSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backupSummaries)
      .optionallyWith(
        lastEvaluatedBackupArn.map(value =>
          BackupArn.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedBackupArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly =
    zio.aws.dynamodb.model.ListBackupsResponse.wrap(buildAwsValue())
}
object ListBackupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListBackupsResponse =
      zio.aws.dynamodb.model.ListBackupsResponse(
        backupSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedBackupArn.map(value => value)
      )
    def backupSummaries
        : Optional[List[zio.aws.dynamodb.model.BackupSummary.ReadOnly]]
    def lastEvaluatedBackupArn: Optional[BackupArn]
    def getBackupSummaries: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.BackupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("backupSummaries", backupSummaries)
    def getLastEvaluatedBackupArn: ZIO[Any, AwsError, BackupArn] = AwsError
      .unwrapOptionField("lastEvaluatedBackupArn", lastEvaluatedBackupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse
  ) extends zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly {
    override val backupSummaries
        : Optional[List[zio.aws.dynamodb.model.BackupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.BackupSummary.wrap(item)
          }.toList
        )
    override val lastEvaluatedBackupArn: Optional[BackupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEvaluatedBackupArn())
        .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse
  ): zio.aws.dynamodb.model.ListBackupsResponse.ReadOnly = new Wrapper(impl)
}
