package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGlobalTablesResponse(
    globalTables: Optional[Iterable[zio.aws.dynamodb.model.GlobalTable]] =
      Optional.Absent,
    lastEvaluatedGlobalTableName: Optional[TableName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse = {
    import ListGlobalTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse
      .builder()
      .optionallyWith(
        globalTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalTables)
      .optionallyWith(
        lastEvaluatedGlobalTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedGlobalTableName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly =
    zio.aws.dynamodb.model.ListGlobalTablesResponse.wrap(buildAwsValue())
}
object ListGlobalTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListGlobalTablesResponse =
      zio.aws.dynamodb.model.ListGlobalTablesResponse(
        globalTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedGlobalTableName.map(value => value)
      )
    def globalTables
        : Optional[List[zio.aws.dynamodb.model.GlobalTable.ReadOnly]]
    def lastEvaluatedGlobalTableName: Optional[TableName]
    def getGlobalTables: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalTable.ReadOnly
    ]] = AwsError.unwrapOptionField("globalTables", globalTables)
    def getLastEvaluatedGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField(
        "lastEvaluatedGlobalTableName",
        lastEvaluatedGlobalTableName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse
  ) extends zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly {
    override val globalTables
        : Optional[List[zio.aws.dynamodb.model.GlobalTable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalTables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalTable.wrap(item)
          }.toList
        )
    override val lastEvaluatedGlobalTableName: Optional[TableName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEvaluatedGlobalTableName())
        .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse
  ): zio.aws.dynamodb.model.ListGlobalTablesResponse.ReadOnly = new Wrapper(
    impl
  )
}
