package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ImportNextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListImportsResponse(
    importSummaryList: Optional[
      Iterable[zio.aws.dynamodb.model.ImportSummary]
    ] = Optional.Absent,
    nextToken: Optional[ImportNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListImportsResponse = {
    import ListImportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListImportsResponse
      .builder()
      .optionallyWith(
        importSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importSummaryList)
      .optionallyWith(
        nextToken.map(value => ImportNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListImportsResponse.ReadOnly =
    zio.aws.dynamodb.model.ListImportsResponse.wrap(buildAwsValue())
}
object ListImportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListImportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListImportsResponse =
      zio.aws.dynamodb.model.ListImportsResponse(
        importSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importSummaryList
        : Optional[List[zio.aws.dynamodb.model.ImportSummary.ReadOnly]]
    def nextToken: Optional[ImportNextToken]
    def getImportSummaryList: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ImportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("importSummaryList", importSummaryList)
    def getNextToken: ZIO[Any, AwsError, ImportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListImportsResponse
  ) extends zio.aws.dynamodb.model.ListImportsResponse.ReadOnly {
    override val importSummaryList
        : Optional[List[zio.aws.dynamodb.model.ImportSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ImportSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[ImportNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.ImportNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListImportsResponse
  ): zio.aws.dynamodb.model.ListImportsResponse.ReadOnly = new Wrapper(impl)
}
