package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.RegionName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicaAutoScalingDescription(
    regionName: Optional[RegionName] = Optional.Absent,
    globalSecondaryIndexes: Optional[Iterable[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
    ]] = Optional.Absent,
    replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent,
    replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription
    ] = Optional.Absent,
    replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription = {
    import ReplicaAutoScalingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription
      .builder()
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedReadCapacityAutoScalingSettings)
      .optionallyWith(
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedWriteCapacityAutoScalingSettings)
      .optionallyWith(replicaStatus.map(value => value.unwrap))(_.replicaStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaAutoScalingDescription.wrap(buildAwsValue())
}
object ReplicaAutoScalingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaAutoScalingDescription =
      zio.aws.dynamodb.model.ReplicaAutoScalingDescription(
        regionName.map(value => value),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaProvisionedReadCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaProvisionedWriteCapacityAutoScalingSettings.map(value =>
          value.asEditable
        ),
        replicaStatus.map(value => value)
      )
    def regionName: Optional[RegionName]
    def globalSecondaryIndexes: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly
    ]]
    def replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ]
    def replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus]
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getReplicaProvisionedReadCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityAutoScalingSettings",
      replicaProvisionedReadCapacityAutoScalingSettings
    )
    def getReplicaProvisionedWriteCapacityAutoScalingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedWriteCapacityAutoScalingSettings",
      replicaProvisionedWriteCapacityAutoScalingSettings
    )
    def getReplicaStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReplicaStatus] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription
  ) extends zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly {
    override val regionName: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
    override val globalSecondaryIndexes: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
            .wrap(item)
        }.toList
      )
    override val replicaProvisionedReadCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.replicaProvisionedReadCapacityAutoScalingSettings()
      )
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaProvisionedWriteCapacityAutoScalingSettings: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.replicaProvisionedWriteCapacityAutoScalingSettings()
      )
      .map(value =>
        zio.aws.dynamodb.model.AutoScalingSettingsDescription.wrap(value)
      )
    override val replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaStatus())
        .map(value => zio.aws.dynamodb.model.ReplicaStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription
  ): zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly =
    new Wrapper(impl)
}
