package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  Date,
  KMSMasterKeyId,
  RegionName,
  ReplicaStatusPercentProgress,
  ReplicaStatusDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicaDescription(
    regionName: Optional[RegionName] = Optional.Absent,
    replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      Optional.Absent,
    replicaStatusDescription: Optional[ReplicaStatusDescription] =
      Optional.Absent,
    replicaStatusPercentProgress: Optional[ReplicaStatusPercentProgress] =
      Optional.Absent,
    kmsMasterKeyId: Optional[KMSMasterKeyId] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = Optional.Absent,
    globalSecondaryIndexes: Optional[
      Iterable[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription]
    ] = Optional.Absent,
    replicaInaccessibleDateTime: Optional[Date] = Optional.Absent,
    replicaTableClassSummary: Optional[
      zio.aws.dynamodb.model.TableClassSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaDescription = {
    import ReplicaDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
      .builder()
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(replicaStatus.map(value => value.unwrap))(_.replicaStatus)
      .optionallyWith(
        replicaStatusDescription.map(value =>
          ReplicaStatusDescription.unwrap(value): java.lang.String
        )
      )(_.replicaStatusDescription)
      .optionallyWith(
        replicaStatusPercentProgress.map(value =>
          ReplicaStatusPercentProgress.unwrap(value): java.lang.String
        )
      )(_.replicaStatusPercentProgress)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          KMSMasterKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        replicaInaccessibleDateTime.map(value => Date.unwrap(value): Instant)
      )(_.replicaInaccessibleDateTime)
      .optionallyWith(
        replicaTableClassSummary.map(value => value.buildAwsValue())
      )(_.replicaTableClassSummary)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaDescription.wrap(buildAwsValue())
}
object ReplicaDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaDescription =
      zio.aws.dynamodb.model.ReplicaDescription(
        regionName.map(value => value),
        replicaStatus.map(value => value),
        replicaStatusDescription.map(value => value),
        replicaStatusPercentProgress.map(value => value),
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaInaccessibleDateTime.map(value => value),
        replicaTableClassSummary.map(value => value.asEditable)
      )
    def regionName: Optional[RegionName]
    def replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus]
    def replicaStatusDescription: Optional[ReplicaStatusDescription]
    def replicaStatusPercentProgress: Optional[ReplicaStatusPercentProgress]
    def kmsMasterKeyId: Optional[KMSMasterKeyId]
    def provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ]
    def globalSecondaryIndexes: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]]
    def replicaInaccessibleDateTime: Optional[Date]
    def replicaTableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getReplicaStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReplicaStatus] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaStatusDescription
        : ZIO[Any, AwsError, ReplicaStatusDescription] = AwsError
      .unwrapOptionField("replicaStatusDescription", replicaStatusDescription)
    def getReplicaStatusPercentProgress
        : ZIO[Any, AwsError, ReplicaStatusPercentProgress] =
      AwsError.unwrapOptionField(
        "replicaStatusPercentProgress",
        replicaStatusPercentProgress
      )
    def getKmsMasterKeyId: ZIO[Any, AwsError, KMSMasterKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getReplicaInaccessibleDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "replicaInaccessibleDateTime",
        replicaInaccessibleDateTime
      )
    def getReplicaTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaTableClassSummary",
      replicaTableClassSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ) extends zio.aws.dynamodb.model.ReplicaDescription.ReadOnly {
    override val regionName: Optional[RegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
    override val replicaStatus: Optional[zio.aws.dynamodb.model.ReplicaStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaStatus())
        .map(value => zio.aws.dynamodb.model.ReplicaStatus.wrap(value))
    override val replicaStatusDescription: Optional[ReplicaStatusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaStatusDescription())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ReplicaStatusDescription(value)
        )
    override val replicaStatusPercentProgress
        : Optional[ReplicaStatusPercentProgress] = zio.aws.core.internal
      .optionalFromNullable(impl.replicaStatusPercentProgress())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ReplicaStatusPercentProgress(value)
      )
    override val kmsMasterKeyId: Optional[KMSMasterKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyId())
        .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyId(value))
    override val provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val globalSecondaryIndexes: Optional[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
            .wrap(item)
        }.toList
      )
    override val replicaInaccessibleDateTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaInaccessibleDateTime())
        .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val replicaTableClassSummary
        : Optional[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaTableClassSummary())
        .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ): zio.aws.dynamodb.model.ReplicaDescription.ReadOnly = new Wrapper(impl)
}
