package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{BackupArn, TableName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RestoreTableFromBackupRequest(
    targetTableName: TableName,
    backupArn: BackupArn,
    billingModeOverride: Optional[zio.aws.dynamodb.model.BillingMode] =
      Optional.Absent,
    globalSecondaryIndexOverride: Optional[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndex]
    ] = Optional.Absent,
    localSecondaryIndexOverride: Optional[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndex]
    ] = Optional.Absent,
    provisionedThroughputOverride: Optional[
      zio.aws.dynamodb.model.ProvisionedThroughput
    ] = Optional.Absent,
    sseSpecificationOverride: Optional[
      zio.aws.dynamodb.model.SSESpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest = {
    import RestoreTableFromBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest
      .builder()
      .targetTableName(TableName.unwrap(targetTableName): java.lang.String)
      .backupArn(BackupArn.unwrap(backupArn): java.lang.String)
      .optionallyWith(billingModeOverride.map(value => value.unwrap))(
        _.billingModeOverride
      )
      .optionallyWith(
        globalSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexOverride)
      .optionallyWith(
        localSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexOverride)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        sseSpecificationOverride.map(value => value.buildAwsValue())
      )(_.sseSpecificationOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.RestoreTableFromBackupRequest.ReadOnly =
    zio.aws.dynamodb.model.RestoreTableFromBackupRequest.wrap(buildAwsValue())
}
object RestoreTableFromBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreTableFromBackupRequest =
      zio.aws.dynamodb.model.RestoreTableFromBackupRequest(
        targetTableName,
        backupArn,
        billingModeOverride.map(value => value),
        globalSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        localSecondaryIndexOverride.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedThroughputOverride.map(value => value.asEditable),
        sseSpecificationOverride.map(value => value.asEditable)
      )
    def targetTableName: TableName
    def backupArn: BackupArn
    def billingModeOverride: Optional[zio.aws.dynamodb.model.BillingMode]
    def globalSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]]
    def localSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]]
    def provisionedThroughputOverride
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly]
    def sseSpecificationOverride
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly]
    def getTargetTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(targetTableName)
    def getBackupArn: ZIO[Any, Nothing, BackupArn] = ZIO.succeed(backupArn)
    def getBillingModeOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] =
      AwsError.unwrapOptionField("billingModeOverride", billingModeOverride)
    def getGlobalSecondaryIndexOverride: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexOverride",
      globalSecondaryIndexOverride
    )
    def getLocalSecondaryIndexOverride: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localSecondaryIndexOverride",
      localSecondaryIndexOverride
    )
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getSseSpecificationOverride
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      AwsError.unwrapOptionField(
        "sseSpecificationOverride",
        sseSpecificationOverride
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest
  ) extends zio.aws.dynamodb.model.RestoreTableFromBackupRequest.ReadOnly {
    override val targetTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.targetTableName())
    override val backupArn: BackupArn =
      zio.aws.dynamodb.model.primitives.BackupArn(impl.backupArn())
    override val billingModeOverride
        : Optional[zio.aws.dynamodb.model.BillingMode] = zio.aws.core.internal
      .optionalFromNullable(impl.billingModeOverride())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val globalSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.GlobalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalSecondaryIndexOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.GlobalSecondaryIndex.wrap(item)
          }.toList
        )
    override val localSecondaryIndexOverride
        : Optional[List[zio.aws.dynamodb.model.LocalSecondaryIndex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localSecondaryIndexOverride())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.LocalSecondaryIndex.wrap(item)
          }.toList
        )
    override val provisionedThroughputOverride
        : Optional[zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughputOverride())
        .map(value => zio.aws.dynamodb.model.ProvisionedThroughput.wrap(value))
    override val sseSpecificationOverride
        : Optional[zio.aws.dynamodb.model.SSESpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseSpecificationOverride())
        .map(value => zio.aws.dynamodb.model.SSESpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest
  ): zio.aws.dynamodb.model.RestoreTableFromBackupRequest.ReadOnly =
    new Wrapper(impl)
}
