package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RestoreTableToPointInTimeResponse(
    tableDescription: Optional[zio.aws.dynamodb.model.TableDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse = {
    import RestoreTableToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly =
    zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse
      .wrap(buildAwsValue())
}
object RestoreTableToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse =
      zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse(
        tableDescription.map(value => value.asEditable)
      )
    def tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ) extends zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly {
    override val tableDescription
        : Optional[zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableDescription())
        .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ): zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly =
    new Wrapper(impl)
}
