package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{
  TimeToLiveAttributeName,
  TimeToLiveEnabled
}
import scala.jdk.CollectionConverters.*
final case class TimeToLiveSpecification(
    enabled: TimeToLiveEnabled,
    attributeName: TimeToLiveAttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification = {
    import TimeToLiveSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification
      .builder()
      .enabled(TimeToLiveEnabled.unwrap(enabled): java.lang.Boolean)
      .attributeName(
        TimeToLiveAttributeName.unwrap(attributeName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly =
    zio.aws.dynamodb.model.TimeToLiveSpecification.wrap(buildAwsValue())
}
object TimeToLiveSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TimeToLiveSpecification =
      zio.aws.dynamodb.model.TimeToLiveSpecification(enabled, attributeName)
    def enabled: TimeToLiveEnabled
    def attributeName: TimeToLiveAttributeName
    def getEnabled: ZIO[Any, Nothing, TimeToLiveEnabled] = ZIO.succeed(enabled)
    def getAttributeName: ZIO[Any, Nothing, TimeToLiveAttributeName] =
      ZIO.succeed(attributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification
  ) extends zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly {
    override val enabled: TimeToLiveEnabled =
      zio.aws.dynamodb.model.primitives.TimeToLiveEnabled(impl.enabled())
    override val attributeName: TimeToLiveAttributeName =
      zio.aws.dynamodb.model.primitives
        .TimeToLiveAttributeName(impl.attributeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification
  ): zio.aws.dynamodb.model.TimeToLiveSpecification.ReadOnly = new Wrapper(impl)
}
