package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{TagKeyString, ResourceArnString}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: ResourceArnString,
    tagKeys: Iterable[TagKeyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKeyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.UntagResourceRequest.ReadOnly =
    zio.aws.dynamodb.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UntagResourceRequest =
      zio.aws.dynamodb.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ResourceArnString
    def tagKeys: List[TagKeyString]
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKeyString]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest
  ) extends zio.aws.dynamodb.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString(impl.resourceArn())
    override val tagKeys: List[TagKeyString] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.primitives.TagKeyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest
  ): zio.aws.dynamodb.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
