package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Value, Name}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttributeConfig(
    attributeName: Name,
    transformations: Map[Name, Value]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.AttributeConfig = {
    import AttributeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.AttributeConfig
      .builder()
      .attributeName(Name.unwrap(attributeName): java.lang.String)
      .transformations(
        transformations
          .map({ case (key, value) =>
            (Name.unwrap(key): java.lang.String) -> (Value
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.AttributeConfig.ReadOnly =
    zio.aws.forecast.model.AttributeConfig.wrap(buildAwsValue())
}
object AttributeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.AttributeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.AttributeConfig =
      zio.aws.forecast.model.AttributeConfig(attributeName, transformations)
    def attributeName: Name
    def transformations: Map[Name, Value]
    def getAttributeName: ZIO[Any, Nothing, Name] = ZIO.succeed(attributeName)
    def getTransformations: ZIO[Any, Nothing, Map[Name, Value]] =
      ZIO.succeed(transformations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.AttributeConfig
  ) extends zio.aws.forecast.model.AttributeConfig.ReadOnly {
    override val attributeName: Name =
      zio.aws.forecast.model.primitives.Name(impl.attributeName())
    override val transformations: Map[Name, Value] = impl
      .transformations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.forecast.model.primitives
          .Name(key) -> zio.aws.forecast.model.primitives.Value(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.AttributeConfig
  ): zio.aws.forecast.model.AttributeConfig.ReadOnly = new Wrapper(impl)
}
