package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ContinuousParameterRange(
    name: Name,
    maxValue: Double,
    minValue: Double,
    scalingType: Optional[zio.aws.forecast.model.ScalingType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ContinuousParameterRange = {
    import ContinuousParameterRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ContinuousParameterRange
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .maxValue(maxValue: java.lang.Double)
      .minValue(minValue: java.lang.Double)
      .optionallyWith(scalingType.map(value => value.unwrap))(_.scalingType)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ContinuousParameterRange.ReadOnly =
    zio.aws.forecast.model.ContinuousParameterRange.wrap(buildAwsValue())
}
object ContinuousParameterRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ContinuousParameterRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ContinuousParameterRange =
      zio.aws.forecast.model.ContinuousParameterRange(
        name,
        maxValue,
        minValue,
        scalingType.map(value => value)
      )
    def name: Name
    def maxValue: Double
    def minValue: Double
    def scalingType: Optional[zio.aws.forecast.model.ScalingType]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getMaxValue: ZIO[Any, Nothing, Double] = ZIO.succeed(maxValue)
    def getMinValue: ZIO[Any, Nothing, Double] = ZIO.succeed(minValue)
    def getScalingType: ZIO[Any, AwsError, zio.aws.forecast.model.ScalingType] =
      AwsError.unwrapOptionField("scalingType", scalingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ContinuousParameterRange
  ) extends zio.aws.forecast.model.ContinuousParameterRange.ReadOnly {
    override val name: Name =
      zio.aws.forecast.model.primitives.Name(impl.name())
    override val maxValue: Double = impl.maxValue(): Double
    override val minValue: Double = impl.minValue(): Double
    override val scalingType: Optional[zio.aws.forecast.model.ScalingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingType())
        .map(value => zio.aws.forecast.model.ScalingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ContinuousParameterRange
  ): zio.aws.forecast.model.ContinuousParameterRange.ReadOnly = new Wrapper(
    impl
  )
}
