package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateForecastResponse(
    forecastArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateForecastResponse = {
    import CreateForecastResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateForecastResponse
      .builder()
      .optionallyWith(
        forecastArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.forecastArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateForecastResponse.ReadOnly =
    zio.aws.forecast.model.CreateForecastResponse.wrap(buildAwsValue())
}
object CreateForecastResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateForecastResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateForecastResponse =
      zio.aws.forecast.model
        .CreateForecastResponse(forecastArn.map(value => value))
    def forecastArn: Optional[Arn]
    def getForecastArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("forecastArn", forecastArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastResponse
  ) extends zio.aws.forecast.model.CreateForecastResponse.ReadOnly {
    override val forecastArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastResponse
  ): zio.aws.forecast.model.CreateForecastResponse.ReadOnly = new Wrapper(impl)
}
