package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait DatasetType {
  def unwrap: software.amazon.awssdk.services.forecast.model.DatasetType
}
object DatasetType {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.DatasetType
  ): zio.aws.forecast.model.DatasetType = value match {
    case software.amazon.awssdk.services.forecast.model.DatasetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.DatasetType.TARGET_TIME_SERIES =>
      val r = TARGET_TIME_SERIES
      r
    case software.amazon.awssdk.services.forecast.model.DatasetType.RELATED_TIME_SERIES =>
      val r = RELATED_TIME_SERIES
      r
    case software.amazon.awssdk.services.forecast.model.DatasetType.ITEM_METADATA =>
      val r = ITEM_METADATA
      r
  }
  case object unknownToSdkVersion extends zio.aws.forecast.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DatasetType =
      software.amazon.awssdk.services.forecast.model.DatasetType.UNKNOWN_TO_SDK_VERSION
  }
  case object TARGET_TIME_SERIES extends zio.aws.forecast.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DatasetType =
      software.amazon.awssdk.services.forecast.model.DatasetType.TARGET_TIME_SERIES
  }
  case object RELATED_TIME_SERIES extends zio.aws.forecast.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DatasetType =
      software.amazon.awssdk.services.forecast.model.DatasetType.RELATED_TIME_SERIES
  }
  case object ITEM_METADATA extends zio.aws.forecast.model.DatasetType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.DatasetType =
      software.amazon.awssdk.services.forecast.model.DatasetType.ITEM_METADATA
  }
}
