package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetImportJobRequest(datasetImportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest = {
    import DescribeDatasetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest
      .builder()
      .datasetImportJobArn(Arn.unwrap(datasetImportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeDatasetImportJobRequest.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetImportJobRequest.wrap(buildAwsValue())
}
object DescribeDatasetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetImportJobRequest =
      zio.aws.forecast.model
        .DescribeDatasetImportJobRequest(datasetImportJobArn)
    def datasetImportJobArn: Arn
    def getDatasetImportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetImportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest
  ) extends zio.aws.forecast.model.DescribeDatasetImportJobRequest.ReadOnly {
    override val datasetImportJobArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetImportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobRequest
  ): zio.aws.forecast.model.DescribeDatasetImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
