package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Message,
  Timestamp,
  Arn,
  LocalDateTime,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeExplainabilityResponse(
    explainabilityArn: Optional[Arn] = Optional.Absent,
    explainabilityName: Optional[Name] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    explainabilityConfig: Optional[
      zio.aws.forecast.model.ExplainabilityConfig
    ] = Optional.Absent,
    enableVisualization: Optional[Boolean] = Optional.Absent,
    dataSource: Optional[zio.aws.forecast.model.DataSource] = Optional.Absent,
    schema: Optional[zio.aws.forecast.model.Schema] = Optional.Absent,
    startDateTime: Optional[LocalDateTime] = Optional.Absent,
    endDateTime: Optional[LocalDateTime] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse = {
    import DescribeExplainabilityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse
      .builder()
      .optionallyWith(
        explainabilityArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.explainabilityArn)
      .optionallyWith(
        explainabilityName.map(value => Name.unwrap(value): java.lang.String)
      )(_.explainabilityName)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(explainabilityConfig.map(value => value.buildAwsValue()))(
        _.explainabilityConfig
      )
      .optionallyWith(
        enableVisualization.map(value => value: java.lang.Boolean)
      )(_.enableVisualization)
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(schema.map(value => value.buildAwsValue()))(_.schema)
      .optionallyWith(
        startDateTime.map(value =>
          LocalDateTime.unwrap(value): java.lang.String
        )
      )(_.startDateTime)
      .optionallyWith(
        endDateTime.map(value => LocalDateTime.unwrap(value): java.lang.String)
      )(_.endDateTime)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly =
    zio.aws.forecast.model.DescribeExplainabilityResponse.wrap(buildAwsValue())
}
object DescribeExplainabilityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeExplainabilityResponse =
      zio.aws.forecast.model.DescribeExplainabilityResponse(
        explainabilityArn.map(value => value),
        explainabilityName.map(value => value),
        resourceArn.map(value => value),
        explainabilityConfig.map(value => value.asEditable),
        enableVisualization.map(value => value),
        dataSource.map(value => value.asEditable),
        schema.map(value => value.asEditable),
        startDateTime.map(value => value),
        endDateTime.map(value => value),
        estimatedTimeRemainingInMinutes.map(value => value),
        message.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def explainabilityArn: Optional[Arn]
    def explainabilityName: Optional[Name]
    def resourceArn: Optional[Arn]
    def explainabilityConfig
        : Optional[zio.aws.forecast.model.ExplainabilityConfig.ReadOnly]
    def enableVisualization: Optional[Boolean]
    def dataSource: Optional[zio.aws.forecast.model.DataSource.ReadOnly]
    def schema: Optional[zio.aws.forecast.model.Schema.ReadOnly]
    def startDateTime: Optional[LocalDateTime]
    def endDateTime: Optional[LocalDateTime]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def message: Optional[Message]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getExplainabilityArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("explainabilityArn", explainabilityArn)
    def getExplainabilityName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("explainabilityName", explainabilityName)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getExplainabilityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.ExplainabilityConfig.ReadOnly
    ] = AwsError.unwrapOptionField("explainabilityConfig", explainabilityConfig)
    def getEnableVisualization: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableVisualization", enableVisualization)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getSchema: ZIO[Any, AwsError, zio.aws.forecast.model.Schema.ReadOnly] =
      AwsError.unwrapOptionField("schema", schema)
    def getStartDateTime: ZIO[Any, AwsError, LocalDateTime] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, LocalDateTime] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse
  ) extends zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly {
    override val explainabilityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val explainabilityName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val explainabilityConfig
        : Optional[zio.aws.forecast.model.ExplainabilityConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainabilityConfig())
        .map(value => zio.aws.forecast.model.ExplainabilityConfig.wrap(value))
    override val enableVisualization: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableVisualization())
      .map(value => value: Boolean)
    override val dataSource
        : Optional[zio.aws.forecast.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.forecast.model.DataSource.wrap(value))
    override val schema: Optional[zio.aws.forecast.model.Schema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value => zio.aws.forecast.model.Schema.wrap(value))
    override val startDateTime: Optional[LocalDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => zio.aws.forecast.model.primitives.LocalDateTime(value))
    override val endDateTime: Optional[LocalDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.forecast.model.primitives.LocalDateTime(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityResponse
  ): zio.aws.forecast.model.DescribeExplainabilityResponse.ReadOnly =
    new Wrapper(impl)
}
