package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeForecastExportJobRequest(forecastExportJobArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest = {
    import DescribeForecastExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest
      .builder()
      .forecastExportJobArn(Arn.unwrap(forecastExportJobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeForecastExportJobRequest.ReadOnly =
    zio.aws.forecast.model.DescribeForecastExportJobRequest
      .wrap(buildAwsValue())
}
object DescribeForecastExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeForecastExportJobRequest =
      zio.aws.forecast.model
        .DescribeForecastExportJobRequest(forecastExportJobArn)
    def forecastExportJobArn: Arn
    def getForecastExportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(forecastExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest
  ) extends zio.aws.forecast.model.DescribeForecastExportJobRequest.ReadOnly {
    override val forecastExportJobArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeForecastExportJobRequest
  ): zio.aws.forecast.model.DescribeForecastExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
