package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ParameterKey,
  ParameterValue,
  Message,
  ForecastType,
  Timestamp,
  Arn,
  Integer,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribePredictorResponse(
    predictorArn: Optional[Name] = Optional.Absent,
    predictorName: Optional[Name] = Optional.Absent,
    algorithmArn: Optional[Arn] = Optional.Absent,
    autoMLAlgorithmArns: Optional[Iterable[Arn]] = Optional.Absent,
    forecastHorizon: Optional[Integer] = Optional.Absent,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    performAutoML: Optional[Boolean] = Optional.Absent,
    autoMLOverrideStrategy: Optional[
      zio.aws.forecast.model.AutoMLOverrideStrategy
    ] = Optional.Absent,
    performHPO: Optional[Boolean] = Optional.Absent,
    trainingParameters: Optional[Map[ParameterKey, ParameterValue]] =
      Optional.Absent,
    evaluationParameters: Optional[
      zio.aws.forecast.model.EvaluationParameters
    ] = Optional.Absent,
    hpoConfig: Optional[zio.aws.forecast.model.HyperParameterTuningJobConfig] =
      Optional.Absent,
    inputDataConfig: Optional[zio.aws.forecast.model.InputDataConfig] =
      Optional.Absent,
    featurizationConfig: Optional[zio.aws.forecast.model.FeaturizationConfig] =
      Optional.Absent,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    predictorExecutionDetails: Optional[
      zio.aws.forecast.model.PredictorExecutionDetails
    ] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    isAutoPredictor: Optional[Boolean] = Optional.Absent,
    datasetImportJobArns: Optional[Iterable[Arn]] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribePredictorResponse = {
    import DescribePredictorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribePredictorResponse
      .builder()
      .optionallyWith(
        predictorArn.map(value => Name.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .optionallyWith(
        predictorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.predictorName)
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(
        autoMLAlgorithmArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoMLAlgorithmArns)
      .optionallyWith(forecastHorizon.map(value => value: java.lang.Integer))(
        _.forecastHorizon
      )
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(performAutoML.map(value => value: java.lang.Boolean))(
        _.performAutoML
      )
      .optionallyWith(autoMLOverrideStrategy.map(value => value.unwrap))(
        _.autoMLOverrideStrategy
      )
      .optionallyWith(performHPO.map(value => value: java.lang.Boolean))(
        _.performHPO
      )
      .optionallyWith(
        trainingParameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterKey.unwrap(key): java.lang.String) -> (ParameterValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.trainingParameters)
      .optionallyWith(evaluationParameters.map(value => value.buildAwsValue()))(
        _.evaluationParameters
      )
      .optionallyWith(hpoConfig.map(value => value.buildAwsValue()))(
        _.hpoConfig
      )
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(featurizationConfig.map(value => value.buildAwsValue()))(
        _.featurizationConfig
      )
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        predictorExecutionDetails.map(value => value.buildAwsValue())
      )(_.predictorExecutionDetails)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(isAutoPredictor.map(value => value: java.lang.Boolean))(
        _.isAutoPredictor
      )
      .optionallyWith(
        datasetImportJobArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetImportJobArns)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(optimizationMetric.map(value => value.unwrap))(
        _.optimizationMetric
      )
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribePredictorResponse.ReadOnly =
    zio.aws.forecast.model.DescribePredictorResponse.wrap(buildAwsValue())
}
object DescribePredictorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribePredictorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribePredictorResponse =
      zio.aws.forecast.model.DescribePredictorResponse(
        predictorArn.map(value => value),
        predictorName.map(value => value),
        algorithmArn.map(value => value),
        autoMLAlgorithmArns.map(value => value),
        forecastHorizon.map(value => value),
        forecastTypes.map(value => value),
        performAutoML.map(value => value),
        autoMLOverrideStrategy.map(value => value),
        performHPO.map(value => value),
        trainingParameters.map(value => value),
        evaluationParameters.map(value => value.asEditable),
        hpoConfig.map(value => value.asEditable),
        inputDataConfig.map(value => value.asEditable),
        featurizationConfig.map(value => value.asEditable),
        encryptionConfig.map(value => value.asEditable),
        predictorExecutionDetails.map(value => value.asEditable),
        estimatedTimeRemainingInMinutes.map(value => value),
        isAutoPredictor.map(value => value),
        datasetImportJobArns.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        optimizationMetric.map(value => value)
      )
    def predictorArn: Optional[Name]
    def predictorName: Optional[Name]
    def algorithmArn: Optional[Arn]
    def autoMLAlgorithmArns: Optional[List[Arn]]
    def forecastHorizon: Optional[Integer]
    def forecastTypes: Optional[List[ForecastType]]
    def performAutoML: Optional[Boolean]
    def autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy]
    def performHPO: Optional[Boolean]
    def trainingParameters: Optional[Map[ParameterKey, ParameterValue]]
    def evaluationParameters
        : Optional[zio.aws.forecast.model.EvaluationParameters.ReadOnly]
    def hpoConfig: Optional[
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ]
    def inputDataConfig
        : Optional[zio.aws.forecast.model.InputDataConfig.ReadOnly]
    def featurizationConfig
        : Optional[zio.aws.forecast.model.FeaturizationConfig.ReadOnly]
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def predictorExecutionDetails
        : Optional[zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def isAutoPredictor: Optional[Boolean]
    def datasetImportJobArns: Optional[List[Arn]]
    def status: Optional[Status]
    def message: Optional[Message]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric]
    def getPredictorArn: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getPredictorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("predictorName", predictorName)
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getAutoMLAlgorithmArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("autoMLAlgorithmArns", autoMLAlgorithmArns)
    def getForecastHorizon: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("forecastHorizon", forecastHorizon)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getPerformAutoML: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performAutoML", performAutoML)
    def getAutoMLOverrideStrategy
        : ZIO[Any, AwsError, zio.aws.forecast.model.AutoMLOverrideStrategy] =
      AwsError.unwrapOptionField(
        "autoMLOverrideStrategy",
        autoMLOverrideStrategy
      )
    def getPerformHPO: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performHPO", performHPO)
    def getTrainingParameters
        : ZIO[Any, AwsError, Map[ParameterKey, ParameterValue]] =
      AwsError.unwrapOptionField("trainingParameters", trainingParameters)
    def getEvaluationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.EvaluationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationParameters", evaluationParameters)
    def getHpoConfig: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ] = AwsError.unwrapOptionField("hpoConfig", hpoConfig)
    def getInputDataConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.InputDataConfig.ReadOnly] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getFeaturizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.FeaturizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("featurizationConfig", featurizationConfig)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getPredictorExecutionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predictorExecutionDetails",
      predictorExecutionDetails
    )
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getIsAutoPredictor: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAutoPredictor", isAutoPredictor)
    def getDatasetImportJobArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("datasetImportJobArns", datasetImportJobArns)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getOptimizationMetric
        : ZIO[Any, AwsError, zio.aws.forecast.model.OptimizationMetric] =
      AwsError.unwrapOptionField("optimizationMetric", optimizationMetric)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorResponse
  ) extends zio.aws.forecast.model.DescribePredictorResponse.ReadOnly {
    override val predictorArn: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val predictorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val autoMLAlgorithmArns: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLAlgorithmArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Arn(item)
          }.toList
        )
    override val forecastHorizon: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastHorizon())
      .map(value => value: Integer)
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val performAutoML: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performAutoML())
      .map(value => value: Boolean)
    override val autoMLOverrideStrategy
        : Optional[zio.aws.forecast.model.AutoMLOverrideStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLOverrideStrategy())
        .map(value => zio.aws.forecast.model.AutoMLOverrideStrategy.wrap(value))
    override val performHPO: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performHPO())
      .map(value => value: Boolean)
    override val trainingParameters
        : Optional[Map[ParameterKey, ParameterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.forecast.model.primitives.ParameterKey(
              key
            ) -> zio.aws.forecast.model.primitives.ParameterValue(value)
          })
          .toMap
      )
    override val evaluationParameters
        : Optional[zio.aws.forecast.model.EvaluationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationParameters())
        .map(value => zio.aws.forecast.model.EvaluationParameters.wrap(value))
    override val hpoConfig: Optional[
      zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hpoConfig())
      .map(value =>
        zio.aws.forecast.model.HyperParameterTuningJobConfig.wrap(value)
      )
    override val inputDataConfig
        : Optional[zio.aws.forecast.model.InputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value => zio.aws.forecast.model.InputDataConfig.wrap(value))
    override val featurizationConfig
        : Optional[zio.aws.forecast.model.FeaturizationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featurizationConfig())
        .map(value => zio.aws.forecast.model.FeaturizationConfig.wrap(value))
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val predictorExecutionDetails
        : Optional[zio.aws.forecast.model.PredictorExecutionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictorExecutionDetails())
        .map(value =>
          zio.aws.forecast.model.PredictorExecutionDetails.wrap(value)
        )
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val isAutoPredictor: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAutoPredictor())
      .map(value => value: Boolean)
    override val datasetImportJobArns: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetImportJobArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Arn(item)
          }.toList
        )
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val optimizationMetric
        : Optional[zio.aws.forecast.model.OptimizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationMetric())
        .map(value => zio.aws.forecast.model.OptimizationMetric.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorResponse
  ): zio.aws.forecast.model.DescribePredictorResponse.ReadOnly = new Wrapper(
    impl
  )
}
