package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationResult(
    algorithmArn: Optional[Arn] = Optional.Absent,
    testWindows: Optional[Iterable[zio.aws.forecast.model.WindowSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.EvaluationResult = {
    import EvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.EvaluationResult
      .builder()
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(
        testWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testWindows)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.EvaluationResult.ReadOnly =
    zio.aws.forecast.model.EvaluationResult.wrap(buildAwsValue())
}
object EvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.EvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.EvaluationResult =
      zio.aws.forecast.model.EvaluationResult(
        algorithmArn.map(value => value),
        testWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def algorithmArn: Optional[Arn]
    def testWindows
        : Optional[List[zio.aws.forecast.model.WindowSummary.ReadOnly]]
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getTestWindows: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.WindowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("testWindows", testWindows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.EvaluationResult
  ) extends zio.aws.forecast.model.EvaluationResult.ReadOnly {
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val testWindows
        : Optional[List[zio.aws.forecast.model.WindowSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testWindows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.WindowSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.EvaluationResult
  ): zio.aws.forecast.model.EvaluationResult.ReadOnly = new Wrapper(impl)
}
