package zio.aws.forecast.model
import scala.jdk.CollectionConverters.*
sealed trait EvaluationType {
  def unwrap: software.amazon.awssdk.services.forecast.model.EvaluationType
}
object EvaluationType {
  def wrap(
      value: software.amazon.awssdk.services.forecast.model.EvaluationType
  ): zio.aws.forecast.model.EvaluationType = value match {
    case software.amazon.awssdk.services.forecast.model.EvaluationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.forecast.model.EvaluationType.SUMMARY =>
      val r = SUMMARY
      r
    case software.amazon.awssdk.services.forecast.model.EvaluationType.COMPUTED =>
      val r = COMPUTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.forecast.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.EvaluationType =
      software.amazon.awssdk.services.forecast.model.EvaluationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUMMARY extends zio.aws.forecast.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.EvaluationType =
      software.amazon.awssdk.services.forecast.model.EvaluationType.SUMMARY
  }
  case object COMPUTED extends zio.aws.forecast.model.EvaluationType {
    override def unwrap
        : software.amazon.awssdk.services.forecast.model.EvaluationType =
      software.amazon.awssdk.services.forecast.model.EvaluationType.COMPUTED
  }
}
