package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDatasetGroupsResponse(
    datasetGroups: Optional[
      Iterable[zio.aws.forecast.model.DatasetGroupSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse = {
    import ListDatasetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse
      .builder()
      .optionallyWith(
        datasetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly =
    zio.aws.forecast.model.ListDatasetGroupsResponse.wrap(buildAwsValue())
}
object ListDatasetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListDatasetGroupsResponse =
      zio.aws.forecast.model.ListDatasetGroupsResponse(
        datasetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetGroups
        : Optional[List[zio.aws.forecast.model.DatasetGroupSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDatasetGroups: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.DatasetGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetGroups", datasetGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse
  ) extends zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly {
    override val datasetGroups
        : Optional[List[zio.aws.forecast.model.DatasetGroupSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.DatasetGroupSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListDatasetGroupsResponse
  ): zio.aws.forecast.model.ListDatasetGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
