package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListForecastExportJobsResponse(
    forecastExportJobs: Optional[
      Iterable[zio.aws.forecast.model.ForecastExportJobSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse = {
    import ListForecastExportJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse
      .builder()
      .optionallyWith(
        forecastExportJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.forecastExportJobs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly =
    zio.aws.forecast.model.ListForecastExportJobsResponse.wrap(buildAwsValue())
}
object ListForecastExportJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ListForecastExportJobsResponse =
      zio.aws.forecast.model.ListForecastExportJobsResponse(
        forecastExportJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def forecastExportJobs: Optional[
      List[zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getForecastExportJobs: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("forecastExportJobs", forecastExportJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse
  ) extends zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly {
    override val forecastExportJobs: Optional[
      List[zio.aws.forecast.model.ForecastExportJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastExportJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.ForecastExportJobSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.forecast.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse
  ): zio.aws.forecast.model.ListForecastExportJobsResponse.ReadOnly =
    new Wrapper(impl)
}
