package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PredictorExecution(
    algorithmArn: Optional[Arn] = Optional.Absent,
    testWindows: Optional[Iterable[zio.aws.forecast.model.TestWindowSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.PredictorExecution = {
    import PredictorExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.PredictorExecution
      .builder()
      .optionallyWith(
        algorithmArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.algorithmArn)
      .optionallyWith(
        testWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testWindows)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.PredictorExecution.ReadOnly =
    zio.aws.forecast.model.PredictorExecution.wrap(buildAwsValue())
}
object PredictorExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.PredictorExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.PredictorExecution =
      zio.aws.forecast.model.PredictorExecution(
        algorithmArn.map(value => value),
        testWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def algorithmArn: Optional[Arn]
    def testWindows
        : Optional[List[zio.aws.forecast.model.TestWindowSummary.ReadOnly]]
    def getAlgorithmArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("algorithmArn", algorithmArn)
    def getTestWindows: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.TestWindowSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("testWindows", testWindows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.PredictorExecution
  ) extends zio.aws.forecast.model.PredictorExecution.ReadOnly {
    override val algorithmArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val testWindows
        : Optional[List[zio.aws.forecast.model.TestWindowSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testWindows())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.TestWindowSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.PredictorExecution
  ): zio.aws.forecast.model.PredictorExecution.ReadOnly = new Wrapper(impl)
}
