package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Schema(
    attributes: Optional[Iterable[zio.aws.forecast.model.SchemaAttribute]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.forecast.model.Schema = {
    import Schema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Schema
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Schema.ReadOnly =
    zio.aws.forecast.model.Schema.wrap(buildAwsValue())
}
object Schema {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.forecast.model.Schema] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Schema =
      zio.aws.forecast.model.Schema(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributes
        : Optional[List[zio.aws.forecast.model.SchemaAttribute.ReadOnly]]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.SchemaAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Schema
  ) extends zio.aws.forecast.model.Schema.ReadOnly {
    override val attributes
        : Optional[List[zio.aws.forecast.model.SchemaAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.SchemaAttribute.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Schema
  ): zio.aws.forecast.model.Schema.ReadOnly = new Wrapper(impl)
}
