package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAutoPredictorResponse(
    predictorArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse = {
    import CreateAutoPredictorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse
      .builder()
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly =
    zio.aws.forecast.model.CreateAutoPredictorResponse.wrap(buildAwsValue())
}
object CreateAutoPredictorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateAutoPredictorResponse =
      zio.aws.forecast.model
        .CreateAutoPredictorResponse(predictorArn.map(value => value))
    def predictorArn: Optional[Arn]
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse
  ) extends zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly {
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateAutoPredictorResponse
  ): zio.aws.forecast.model.CreateAutoPredictorResponse.ReadOnly = new Wrapper(
    impl
  )
}
