package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetGroupRequest(
    datasetGroupName: Name,
    domain: zio.aws.forecast.model.Domain,
    datasetArns: Optional[Iterable[Arn]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest = {
    import CreateDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest
      .builder()
      .datasetGroupName(Name.unwrap(datasetGroupName): java.lang.String)
      .domain(domain.unwrap)
      .optionallyWith(
        datasetArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetArns)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateDatasetGroupRequest.ReadOnly =
    zio.aws.forecast.model.CreateDatasetGroupRequest.wrap(buildAwsValue())
}
object CreateDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetGroupRequest =
      zio.aws.forecast.model.CreateDatasetGroupRequest(
        datasetGroupName,
        domain,
        datasetArns.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetGroupName: Name
    def domain: zio.aws.forecast.model.Domain
    def datasetArns: Optional[List[Arn]]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getDatasetGroupName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(datasetGroupName)
    def getDomain: ZIO[Any, Nothing, zio.aws.forecast.model.Domain] =
      ZIO.succeed(domain)
    def getDatasetArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("datasetArns", datasetArns)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest
  ) extends zio.aws.forecast.model.CreateDatasetGroupRequest.ReadOnly {
    override val datasetGroupName: Name =
      zio.aws.forecast.model.primitives.Name(impl.datasetGroupName())
    override val domain: zio.aws.forecast.model.Domain =
      zio.aws.forecast.model.Domain.wrap(impl.domain())
    override val datasetArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.forecast.model.primitives.Arn(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetGroupRequest
  ): zio.aws.forecast.model.CreateDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
