package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Frequency, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDatasetRequest(
    datasetName: Name,
    domain: zio.aws.forecast.model.Domain,
    datasetType: zio.aws.forecast.model.DatasetType,
    dataFrequency: Optional[Frequency] = Optional.Absent,
    schema: zio.aws.forecast.model.Schema,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateDatasetRequest = {
    import CreateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateDatasetRequest
      .builder()
      .datasetName(Name.unwrap(datasetName): java.lang.String)
      .domain(domain.unwrap)
      .datasetType(datasetType.unwrap)
      .optionallyWith(
        dataFrequency.map(value => Frequency.unwrap(value): java.lang.String)
      )(_.dataFrequency)
      .schema(schema.buildAwsValue())
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.CreateDatasetRequest.ReadOnly =
    zio.aws.forecast.model.CreateDatasetRequest.wrap(buildAwsValue())
}
object CreateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateDatasetRequest =
      zio.aws.forecast.model.CreateDatasetRequest(
        datasetName,
        domain,
        datasetType,
        dataFrequency.map(value => value),
        schema.asEditable,
        encryptionConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetName: Name
    def domain: zio.aws.forecast.model.Domain
    def datasetType: zio.aws.forecast.model.DatasetType
    def dataFrequency: Optional[Frequency]
    def schema: zio.aws.forecast.model.Schema.ReadOnly
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getDatasetName: ZIO[Any, Nothing, Name] = ZIO.succeed(datasetName)
    def getDomain: ZIO[Any, Nothing, zio.aws.forecast.model.Domain] =
      ZIO.succeed(domain)
    def getDatasetType: ZIO[Any, Nothing, zio.aws.forecast.model.DatasetType] =
      ZIO.succeed(datasetType)
    def getDataFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("dataFrequency", dataFrequency)
    def getSchema: ZIO[Any, Nothing, zio.aws.forecast.model.Schema.ReadOnly] =
      ZIO.succeed(schema)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetRequest
  ) extends zio.aws.forecast.model.CreateDatasetRequest.ReadOnly {
    override val datasetName: Name =
      zio.aws.forecast.model.primitives.Name(impl.datasetName())
    override val domain: zio.aws.forecast.model.Domain =
      zio.aws.forecast.model.Domain.wrap(impl.domain())
    override val datasetType: zio.aws.forecast.model.DatasetType =
      zio.aws.forecast.model.DatasetType.wrap(impl.datasetType())
    override val dataFrequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.dataFrequency())
      .map(value => zio.aws.forecast.model.primitives.Frequency(value))
    override val schema: zio.aws.forecast.model.Schema.ReadOnly =
      zio.aws.forecast.model.Schema.wrap(impl.schema())
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateDatasetRequest
  ): zio.aws.forecast.model.CreateDatasetRequest.ReadOnly = new Wrapper(impl)
}
