package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateExplainabilityExportRequest(
    explainabilityExportName: Name,
    explainabilityArn: Arn,
    destination: zio.aws.forecast.model.DataDestination,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest = {
    import CreateExplainabilityExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest
      .builder()
      .explainabilityExportName(
        Name.unwrap(explainabilityExportName): java.lang.String
      )
      .explainabilityArn(Arn.unwrap(explainabilityArn): java.lang.String)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateExplainabilityExportRequest.ReadOnly =
    zio.aws.forecast.model.CreateExplainabilityExportRequest
      .wrap(buildAwsValue())
}
object CreateExplainabilityExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateExplainabilityExportRequest =
      zio.aws.forecast.model.CreateExplainabilityExportRequest(
        explainabilityExportName,
        explainabilityArn,
        destination.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def explainabilityExportName: Name
    def explainabilityArn: Arn
    def destination: zio.aws.forecast.model.DataDestination.ReadOnly
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getExplainabilityExportName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(explainabilityExportName)
    def getExplainabilityArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(explainabilityArn)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.forecast.model.DataDestination.ReadOnly] =
      ZIO.succeed(destination)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest
  ) extends zio.aws.forecast.model.CreateExplainabilityExportRequest.ReadOnly {
    override val explainabilityExportName: Name =
      zio.aws.forecast.model.primitives.Name(impl.explainabilityExportName())
    override val explainabilityArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.explainabilityArn())
    override val destination: zio.aws.forecast.model.DataDestination.ReadOnly =
      zio.aws.forecast.model.DataDestination.wrap(impl.destination())
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateExplainabilityExportRequest
  ): zio.aws.forecast.model.CreateExplainabilityExportRequest.ReadOnly =
    new Wrapper(impl)
}
