package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Arn, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateForecastExportJobRequest(
    forecastExportJobName: Name,
    forecastArn: Arn,
    destination: zio.aws.forecast.model.DataDestination,
    tags: Optional[Iterable[zio.aws.forecast.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest = {
    import CreateForecastExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest
      .builder()
      .forecastExportJobName(
        Name.unwrap(forecastExportJobName): java.lang.String
      )
      .forecastArn(Arn.unwrap(forecastArn): java.lang.String)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.CreateForecastExportJobRequest.ReadOnly =
    zio.aws.forecast.model.CreateForecastExportJobRequest.wrap(buildAwsValue())
}
object CreateForecastExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.CreateForecastExportJobRequest =
      zio.aws.forecast.model.CreateForecastExportJobRequest(
        forecastExportJobName,
        forecastArn,
        destination.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def forecastExportJobName: Name
    def forecastArn: Arn
    def destination: zio.aws.forecast.model.DataDestination.ReadOnly
    def tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]]
    def getForecastExportJobName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(forecastExportJobName)
    def getForecastArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(forecastArn)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.forecast.model.DataDestination.ReadOnly] =
      ZIO.succeed(destination)
    def getTags: ZIO[Any, AwsError, List[zio.aws.forecast.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest
  ) extends zio.aws.forecast.model.CreateForecastExportJobRequest.ReadOnly {
    override val forecastExportJobName: Name =
      zio.aws.forecast.model.primitives.Name(impl.forecastExportJobName())
    override val forecastArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.forecastArn())
    override val destination: zio.aws.forecast.model.DataDestination.ReadOnly =
      zio.aws.forecast.model.DataDestination.wrap(impl.destination())
    override val tags: Optional[List[zio.aws.forecast.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.CreateForecastExportJobRequest
  ): zio.aws.forecast.model.CreateForecastExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
