package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Timestamp, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetGroupSummary(
    datasetGroupArn: Optional[Arn] = Optional.Absent,
    datasetGroupName: Optional[Name] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DatasetGroupSummary = {
    import DatasetGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DatasetGroupSummary
      .builder()
      .optionallyWith(
        datasetGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetGroupArn)
      .optionallyWith(
        datasetGroupName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetGroupName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DatasetGroupSummary.ReadOnly =
    zio.aws.forecast.model.DatasetGroupSummary.wrap(buildAwsValue())
}
object DatasetGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DatasetGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DatasetGroupSummary =
      zio.aws.forecast.model.DatasetGroupSummary(
        datasetGroupArn.map(value => value),
        datasetGroupName.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetGroupArn: Optional[Arn]
    def datasetGroupName: Optional[Name]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetGroupArn", datasetGroupArn)
    def getDatasetGroupName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetGroupName", datasetGroupName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DatasetGroupSummary
  ) extends zio.aws.forecast.model.DatasetGroupSummary.ReadOnly {
    override val datasetGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetGroupName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetGroupName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DatasetGroupSummary
  ): zio.aws.forecast.model.DatasetGroupSummary.ReadOnly = new Wrapper(impl)
}
