package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  ErrorMessage,
  Timestamp,
  Arn,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DatasetImportJobSummary(
    datasetImportJobArn: Optional[Arn] = Optional.Absent,
    datasetImportJobName: Optional[Name] = Optional.Absent,
    dataSource: Optional[zio.aws.forecast.model.DataSource] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary = {
    import DatasetImportJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary
      .builder()
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        datasetImportJobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetImportJobName)
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly =
    zio.aws.forecast.model.DatasetImportJobSummary.wrap(buildAwsValue())
}
object DatasetImportJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DatasetImportJobSummary =
      zio.aws.forecast.model.DatasetImportJobSummary(
        datasetImportJobArn.map(value => value),
        datasetImportJobName.map(value => value),
        dataSource.map(value => value.asEditable),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetImportJobArn: Optional[Arn]
    def datasetImportJobName: Optional[Name]
    def dataSource: Optional[zio.aws.forecast.model.DataSource.ReadOnly]
    def status: Optional[Status]
    def message: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getDatasetImportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetImportJobName", datasetImportJobName)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary
  ) extends zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly {
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetImportJobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val dataSource
        : Optional[zio.aws.forecast.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.forecast.model.DataSource.wrap(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DatasetImportJobSummary
  ): zio.aws.forecast.model.DatasetImportJobSummary.ReadOnly = new Wrapper(impl)
}
