package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetGroupRequest(datasetGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest = {
    import DeleteDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteDatasetGroupRequest.ReadOnly =
    zio.aws.forecast.model.DeleteDatasetGroupRequest.wrap(buildAwsValue())
}
object DeleteDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteDatasetGroupRequest =
      zio.aws.forecast.model.DeleteDatasetGroupRequest(datasetGroupArn)
    def datasetGroupArn: Arn
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest
  ) extends zio.aws.forecast.model.DeleteDatasetGroupRequest.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetGroupRequest
  ): zio.aws.forecast.model.DeleteDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
