package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetRequest(datasetArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest
      .builder()
      .datasetArn(Arn.unwrap(datasetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.forecast.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteDatasetRequest =
      zio.aws.forecast.model.DeleteDatasetRequest(datasetArn)
    def datasetArn: Arn
    def getDatasetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(datasetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest
  ) extends zio.aws.forecast.model.DeleteDatasetRequest.ReadOnly {
    override val datasetArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteDatasetRequest
  ): zio.aws.forecast.model.DeleteDatasetRequest.ReadOnly = new Wrapper(impl)
}
