package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteExplainabilityExportRequest(
    explainabilityExportArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest = {
    import DeleteExplainabilityExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest
      .builder()
      .explainabilityExportArn(
        Arn.unwrap(explainabilityExportArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DeleteExplainabilityExportRequest.ReadOnly =
    zio.aws.forecast.model.DeleteExplainabilityExportRequest
      .wrap(buildAwsValue())
}
object DeleteExplainabilityExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DeleteExplainabilityExportRequest =
      zio.aws.forecast.model
        .DeleteExplainabilityExportRequest(explainabilityExportArn)
    def explainabilityExportArn: Arn
    def getExplainabilityExportArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(explainabilityExportArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest
  ) extends zio.aws.forecast.model.DeleteExplainabilityExportRequest.ReadOnly {
    override val explainabilityExportArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.explainabilityExportArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DeleteExplainabilityExportRequest
  ): zio.aws.forecast.model.DeleteExplainabilityExportRequest.ReadOnly =
    new Wrapper(impl)
}
