package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  Frequency,
  Message,
  ForecastType,
  Timestamp,
  Arn,
  Integer,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeAutoPredictorResponse(
    predictorArn: Optional[Arn] = Optional.Absent,
    predictorName: Optional[Name] = Optional.Absent,
    forecastHorizon: Optional[Integer] = Optional.Absent,
    forecastTypes: Optional[Iterable[ForecastType]] = Optional.Absent,
    forecastFrequency: Optional[Frequency] = Optional.Absent,
    forecastDimensions: Optional[Iterable[Name]] = Optional.Absent,
    datasetImportJobArns: Optional[Iterable[Arn]] = Optional.Absent,
    dataConfig: Optional[zio.aws.forecast.model.DataConfig] = Optional.Absent,
    encryptionConfig: Optional[zio.aws.forecast.model.EncryptionConfig] =
      Optional.Absent,
    referencePredictorSummary: Optional[
      zio.aws.forecast.model.ReferencePredictorSummary
    ] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric] =
      Optional.Absent,
    explainabilityInfo: Optional[zio.aws.forecast.model.ExplainabilityInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse = {
    import DescribeAutoPredictorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse
      .builder()
      .optionallyWith(
        predictorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.predictorArn)
      .optionallyWith(
        predictorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.predictorName)
      .optionallyWith(forecastHorizon.map(value => value: java.lang.Integer))(
        _.forecastHorizon
      )
      .optionallyWith(
        forecastTypes.map(value =>
          value.map { item =>
            ForecastType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastTypes)
      .optionallyWith(
        forecastFrequency.map(value =>
          Frequency.unwrap(value): java.lang.String
        )
      )(_.forecastFrequency)
      .optionallyWith(
        forecastDimensions.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.forecastDimensions)
      .optionallyWith(
        datasetImportJobArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.datasetImportJobArns)
      .optionallyWith(dataConfig.map(value => value.buildAwsValue()))(
        _.dataConfig
      )
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .optionallyWith(
        referencePredictorSummary.map(value => value.buildAwsValue())
      )(_.referencePredictorSummary)
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(optimizationMetric.map(value => value.unwrap))(
        _.optimizationMetric
      )
      .optionallyWith(explainabilityInfo.map(value => value.buildAwsValue()))(
        _.explainabilityInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly =
    zio.aws.forecast.model.DescribeAutoPredictorResponse.wrap(buildAwsValue())
}
object DescribeAutoPredictorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeAutoPredictorResponse =
      zio.aws.forecast.model.DescribeAutoPredictorResponse(
        predictorArn.map(value => value),
        predictorName.map(value => value),
        forecastHorizon.map(value => value),
        forecastTypes.map(value => value),
        forecastFrequency.map(value => value),
        forecastDimensions.map(value => value),
        datasetImportJobArns.map(value => value),
        dataConfig.map(value => value.asEditable),
        encryptionConfig.map(value => value.asEditable),
        referencePredictorSummary.map(value => value.asEditable),
        estimatedTimeRemainingInMinutes.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        optimizationMetric.map(value => value),
        explainabilityInfo.map(value => value.asEditable)
      )
    def predictorArn: Optional[Arn]
    def predictorName: Optional[Name]
    def forecastHorizon: Optional[Integer]
    def forecastTypes: Optional[List[ForecastType]]
    def forecastFrequency: Optional[Frequency]
    def forecastDimensions: Optional[List[Name]]
    def datasetImportJobArns: Optional[List[Arn]]
    def dataConfig: Optional[zio.aws.forecast.model.DataConfig.ReadOnly]
    def encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly]
    def referencePredictorSummary
        : Optional[zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def status: Optional[Status]
    def message: Optional[Message]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def optimizationMetric: Optional[zio.aws.forecast.model.OptimizationMetric]
    def explainabilityInfo
        : Optional[zio.aws.forecast.model.ExplainabilityInfo.ReadOnly]
    def getPredictorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("predictorArn", predictorArn)
    def getPredictorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("predictorName", predictorName)
    def getForecastHorizon: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("forecastHorizon", forecastHorizon)
    def getForecastTypes: ZIO[Any, AwsError, List[ForecastType]] =
      AwsError.unwrapOptionField("forecastTypes", forecastTypes)
    def getForecastFrequency: ZIO[Any, AwsError, Frequency] =
      AwsError.unwrapOptionField("forecastFrequency", forecastFrequency)
    def getForecastDimensions: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("forecastDimensions", forecastDimensions)
    def getDatasetImportJobArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("datasetImportJobArns", datasetImportJobArns)
    def getDataConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataConfig.ReadOnly] =
      AwsError.unwrapOptionField("dataConfig", dataConfig)
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
    def getReferencePredictorSummary: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "referencePredictorSummary",
      referencePredictorSummary
    )
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getOptimizationMetric
        : ZIO[Any, AwsError, zio.aws.forecast.model.OptimizationMetric] =
      AwsError.unwrapOptionField("optimizationMetric", optimizationMetric)
    def getExplainabilityInfo: ZIO[
      Any,
      AwsError,
      zio.aws.forecast.model.ExplainabilityInfo.ReadOnly
    ] = AwsError.unwrapOptionField("explainabilityInfo", explainabilityInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse
  ) extends zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly {
    override val predictorArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val predictorName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.predictorName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val forecastHorizon: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastHorizon())
      .map(value => value: Integer)
    override val forecastTypes: Optional[List[ForecastType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.ForecastType(item)
          }.toList
        )
    override val forecastFrequency: Optional[Frequency] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastFrequency())
      .map(value => zio.aws.forecast.model.primitives.Frequency(value))
    override val forecastDimensions: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forecastDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Name(item)
          }.toList
        )
    override val datasetImportJobArns: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetImportJobArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.primitives.Arn(item)
          }.toList
        )
    override val dataConfig
        : Optional[zio.aws.forecast.model.DataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataConfig())
        .map(value => zio.aws.forecast.model.DataConfig.wrap(value))
    override val encryptionConfig
        : Optional[zio.aws.forecast.model.EncryptionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionConfig())
        .map(value => zio.aws.forecast.model.EncryptionConfig.wrap(value))
    override val referencePredictorSummary
        : Optional[zio.aws.forecast.model.ReferencePredictorSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referencePredictorSummary())
        .map(value =>
          zio.aws.forecast.model.ReferencePredictorSummary.wrap(value)
        )
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val optimizationMetric
        : Optional[zio.aws.forecast.model.OptimizationMetric] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optimizationMetric())
        .map(value => zio.aws.forecast.model.OptimizationMetric.wrap(value))
    override val explainabilityInfo
        : Optional[zio.aws.forecast.model.ExplainabilityInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainabilityInfo())
        .map(value => zio.aws.forecast.model.ExplainabilityInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeAutoPredictorResponse
  ): zio.aws.forecast.model.DescribeAutoPredictorResponse.ReadOnly =
    new Wrapper(impl)
}
