package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetGroupRequest(datasetGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest = {
    import DescribeDatasetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest
      .builder()
      .datasetGroupArn(Arn.unwrap(datasetGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribeDatasetGroupRequest.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetGroupRequest.wrap(buildAwsValue())
}
object DescribeDatasetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetGroupRequest =
      zio.aws.forecast.model.DescribeDatasetGroupRequest(datasetGroupArn)
    def datasetGroupArn: Arn
    def getDatasetGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(datasetGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest
  ) extends zio.aws.forecast.model.DescribeDatasetGroupRequest.ReadOnly {
    override val datasetGroupArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.datasetGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetGroupRequest
  ): zio.aws.forecast.model.DescribeDatasetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
