package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{
  Status,
  UseGeolocationForTimeZone,
  Message,
  Timestamp,
  Arn,
  GeolocationFormat,
  TimeZone,
  TimestampFormat,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeDatasetImportJobResponse(
    datasetImportJobName: Optional[Name] = Optional.Absent,
    datasetImportJobArn: Optional[Arn] = Optional.Absent,
    datasetArn: Optional[Arn] = Optional.Absent,
    timestampFormat: Optional[TimestampFormat] = Optional.Absent,
    timeZone: Optional[TimeZone] = Optional.Absent,
    useGeolocationForTimeZone: Optional[UseGeolocationForTimeZone] =
      Optional.Absent,
    geolocationFormat: Optional[GeolocationFormat] = Optional.Absent,
    dataSource: Optional[zio.aws.forecast.model.DataSource] = Optional.Absent,
    estimatedTimeRemainingInMinutes: Optional[Long] = Optional.Absent,
    fieldStatistics: Optional[Map[String, zio.aws.forecast.model.Statistics]] =
      Optional.Absent,
    dataSize: Optional[Double] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse = {
    import DescribeDatasetImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse
      .builder()
      .optionallyWith(
        datasetImportJobName.map(value => Name.unwrap(value): java.lang.String)
      )(_.datasetImportJobName)
      .optionallyWith(
        datasetImportJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetImportJobArn)
      .optionallyWith(
        datasetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        timestampFormat.map(value =>
          TimestampFormat.unwrap(value): java.lang.String
        )
      )(_.timestampFormat)
      .optionallyWith(
        timeZone.map(value => TimeZone.unwrap(value): java.lang.String)
      )(_.timeZone)
      .optionallyWith(
        useGeolocationForTimeZone.map(value =>
          UseGeolocationForTimeZone.unwrap(value): java.lang.Boolean
        )
      )(_.useGeolocationForTimeZone)
      .optionallyWith(
        geolocationFormat.map(value =>
          GeolocationFormat.unwrap(value): java.lang.String
        )
      )(_.geolocationFormat)
      .optionallyWith(dataSource.map(value => value.buildAwsValue()))(
        _.dataSource
      )
      .optionallyWith(
        estimatedTimeRemainingInMinutes.map(value => value: java.lang.Long)
      )(_.estimatedTimeRemainingInMinutes)
      .optionallyWith(
        fieldStatistics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.fieldStatistics)
      .optionallyWith(dataSize.map(value => value: java.lang.Double))(
        _.dataSize
      )
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly =
    zio.aws.forecast.model.DescribeDatasetImportJobResponse
      .wrap(buildAwsValue())
}
object DescribeDatasetImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribeDatasetImportJobResponse =
      zio.aws.forecast.model.DescribeDatasetImportJobResponse(
        datasetImportJobName.map(value => value),
        datasetImportJobArn.map(value => value),
        datasetArn.map(value => value),
        timestampFormat.map(value => value),
        timeZone.map(value => value),
        useGeolocationForTimeZone.map(value => value),
        geolocationFormat.map(value => value),
        dataSource.map(value => value.asEditable),
        estimatedTimeRemainingInMinutes.map(value => value),
        fieldStatistics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        dataSize.map(value => value),
        status.map(value => value),
        message.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def datasetImportJobName: Optional[Name]
    def datasetImportJobArn: Optional[Arn]
    def datasetArn: Optional[Arn]
    def timestampFormat: Optional[TimestampFormat]
    def timeZone: Optional[TimeZone]
    def useGeolocationForTimeZone: Optional[UseGeolocationForTimeZone]
    def geolocationFormat: Optional[GeolocationFormat]
    def dataSource: Optional[zio.aws.forecast.model.DataSource.ReadOnly]
    def estimatedTimeRemainingInMinutes: Optional[Long]
    def fieldStatistics
        : Optional[Map[String, zio.aws.forecast.model.Statistics.ReadOnly]]
    def dataSize: Optional[Double]
    def status: Optional[Status]
    def message: Optional[Message]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getDatasetImportJobName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("datasetImportJobName", datasetImportJobName)
    def getDatasetImportJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetImportJobArn", datasetImportJobArn)
    def getDatasetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getTimestampFormat: ZIO[Any, AwsError, TimestampFormat] =
      AwsError.unwrapOptionField("timestampFormat", timestampFormat)
    def getTimeZone: ZIO[Any, AwsError, TimeZone] =
      AwsError.unwrapOptionField("timeZone", timeZone)
    def getUseGeolocationForTimeZone
        : ZIO[Any, AwsError, UseGeolocationForTimeZone] = AwsError
      .unwrapOptionField("useGeolocationForTimeZone", useGeolocationForTimeZone)
    def getGeolocationFormat: ZIO[Any, AwsError, GeolocationFormat] =
      AwsError.unwrapOptionField("geolocationFormat", geolocationFormat)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataSource.ReadOnly] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getEstimatedTimeRemainingInMinutes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedTimeRemainingInMinutes",
        estimatedTimeRemainingInMinutes
      )
    def getFieldStatistics: ZIO[Any, AwsError, Map[
      String,
      zio.aws.forecast.model.Statistics.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldStatistics", fieldStatistics)
    def getDataSize: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("dataSize", dataSize)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse
  ) extends zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly {
    override val datasetImportJobName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobName())
      .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val datasetImportJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetImportJobArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val datasetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val timestampFormat: Optional[TimestampFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampFormat())
        .map(value => zio.aws.forecast.model.primitives.TimestampFormat(value))
    override val timeZone: Optional[TimeZone] = zio.aws.core.internal
      .optionalFromNullable(impl.timeZone())
      .map(value => zio.aws.forecast.model.primitives.TimeZone(value))
    override val useGeolocationForTimeZone
        : Optional[UseGeolocationForTimeZone] = zio.aws.core.internal
      .optionalFromNullable(impl.useGeolocationForTimeZone())
      .map(value =>
        zio.aws.forecast.model.primitives.UseGeolocationForTimeZone(value)
      )
    override val geolocationFormat: Optional[GeolocationFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geolocationFormat())
        .map(value =>
          zio.aws.forecast.model.primitives.GeolocationFormat(value)
        )
    override val dataSource
        : Optional[zio.aws.forecast.model.DataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.forecast.model.DataSource.wrap(value))
    override val estimatedTimeRemainingInMinutes: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedTimeRemainingInMinutes())
        .map(value => value: Long)
    override val fieldStatistics
        : Optional[Map[String, zio.aws.forecast.model.Statistics.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldStatistics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.forecast.model.Statistics.wrap(value)
            })
            .toMap
        )
    override val dataSize: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSize())
      .map(value => value: Double)
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeDatasetImportJobResponse
  ): zio.aws.forecast.model.DescribeDatasetImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
