package zio.aws.forecast.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.forecast.model.primitives.{Status, Message, Timestamp, Arn, Name}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeExplainabilityExportResponse(
    explainabilityExportArn: Optional[Arn] = Optional.Absent,
    explainabilityExportName: Optional[Name] = Optional.Absent,
    explainabilityArn: Optional[Arn] = Optional.Absent,
    destination: Optional[zio.aws.forecast.model.DataDestination] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse = {
    import DescribeExplainabilityExportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse
      .builder()
      .optionallyWith(
        explainabilityExportArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.explainabilityExportArn)
      .optionallyWith(
        explainabilityExportName.map(value =>
          Name.unwrap(value): java.lang.String
        )
      )(_.explainabilityExportName)
      .optionallyWith(
        explainabilityArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.explainabilityArn)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly =
    zio.aws.forecast.model.DescribeExplainabilityExportResponse
      .wrap(buildAwsValue())
}
object DescribeExplainabilityExportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.DescribeExplainabilityExportResponse =
      zio.aws.forecast.model.DescribeExplainabilityExportResponse(
        explainabilityExportArn.map(value => value),
        explainabilityExportName.map(value => value),
        explainabilityArn.map(value => value),
        destination.map(value => value.asEditable),
        message.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def explainabilityExportArn: Optional[Arn]
    def explainabilityExportName: Optional[Name]
    def explainabilityArn: Optional[Arn]
    def destination: Optional[zio.aws.forecast.model.DataDestination.ReadOnly]
    def message: Optional[Message]
    def status: Optional[Status]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getExplainabilityExportArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("explainabilityExportArn", explainabilityExportArn)
    def getExplainabilityExportName: ZIO[Any, AwsError, Name] = AwsError
      .unwrapOptionField("explainabilityExportName", explainabilityExportName)
    def getExplainabilityArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("explainabilityArn", explainabilityArn)
    def getDestination
        : ZIO[Any, AwsError, zio.aws.forecast.model.DataDestination.ReadOnly] =
      AwsError.unwrapOptionField("destination", destination)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse
  ) extends zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly {
    override val explainabilityExportArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityExportArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val explainabilityExportName: Optional[Name] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainabilityExportName())
        .map(value => zio.aws.forecast.model.primitives.Name(value))
    override val explainabilityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val destination
        : Optional[zio.aws.forecast.model.DataDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.forecast.model.DataDestination.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.forecast.model.primitives.Message(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.forecast.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribeExplainabilityExportResponse
  ): zio.aws.forecast.model.DescribeExplainabilityExportResponse.ReadOnly =
    new Wrapper(impl)
}
