package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribePredictorBacktestExportJobRequest(
    predictorBacktestExportJobArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest = {
    import DescribePredictorBacktestExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest
      .builder()
      .predictorBacktestExportJobArn(
        Arn.unwrap(predictorBacktestExportJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest.ReadOnly =
    zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest
      .wrap(buildAwsValue())
}
object DescribePredictorBacktestExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest =
      zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest(
        predictorBacktestExportJobArn
      )
    def predictorBacktestExportJobArn: Arn
    def getPredictorBacktestExportJobArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(predictorBacktestExportJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest
  ) extends zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest.ReadOnly {
    override val predictorBacktestExportJobArn: Arn =
      zio.aws.forecast.model.primitives
        .Arn(impl.predictorBacktestExportJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorBacktestExportJobRequest
  ): zio.aws.forecast.model.DescribePredictorBacktestExportJobRequest.ReadOnly =
    new Wrapper(impl)
}
