package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribePredictorRequest(predictorArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.DescribePredictorRequest = {
    import DescribePredictorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.DescribePredictorRequest
      .builder()
      .predictorArn(Arn.unwrap(predictorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.DescribePredictorRequest.ReadOnly =
    zio.aws.forecast.model.DescribePredictorRequest.wrap(buildAwsValue())
}
object DescribePredictorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.DescribePredictorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.DescribePredictorRequest =
      zio.aws.forecast.model.DescribePredictorRequest(predictorArn)
    def predictorArn: Arn
    def getPredictorArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(predictorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorRequest
  ) extends zio.aws.forecast.model.DescribePredictorRequest.ReadOnly {
    override val predictorArn: Arn =
      zio.aws.forecast.model.primitives.Arn(impl.predictorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.DescribePredictorRequest
  ): zio.aws.forecast.model.DescribePredictorRequest.ReadOnly = new Wrapper(
    impl
  )
}
