package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.ForecastType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ErrorMetric(
    forecastType: Optional[ForecastType] = Optional.Absent,
    wape: Optional[Double] = Optional.Absent,
    rmse: Optional[Double] = Optional.Absent,
    mase: Optional[Double] = Optional.Absent,
    mape: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ErrorMetric = {
    import ErrorMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ErrorMetric
      .builder()
      .optionallyWith(
        forecastType.map(value => ForecastType.unwrap(value): java.lang.String)
      )(_.forecastType)
      .optionallyWith(wape.map(value => value: java.lang.Double))(_.wape)
      .optionallyWith(rmse.map(value => value: java.lang.Double))(_.rmse)
      .optionallyWith(mase.map(value => value: java.lang.Double))(_.mase)
      .optionallyWith(mape.map(value => value: java.lang.Double))(_.mape)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ErrorMetric.ReadOnly =
    zio.aws.forecast.model.ErrorMetric.wrap(buildAwsValue())
}
object ErrorMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ErrorMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ErrorMetric =
      zio.aws.forecast.model.ErrorMetric(
        forecastType.map(value => value),
        wape.map(value => value),
        rmse.map(value => value),
        mase.map(value => value),
        mape.map(value => value)
      )
    def forecastType: Optional[ForecastType]
    def wape: Optional[Double]
    def rmse: Optional[Double]
    def mase: Optional[Double]
    def mape: Optional[Double]
    def getForecastType: ZIO[Any, AwsError, ForecastType] =
      AwsError.unwrapOptionField("forecastType", forecastType)
    def getWape: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("wape", wape)
    def getRmse: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("rmse", rmse)
    def getMase: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("mase", mase)
    def getMape: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("mape", mape)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ErrorMetric
  ) extends zio.aws.forecast.model.ErrorMetric.ReadOnly {
    override val forecastType: Optional[ForecastType] = zio.aws.core.internal
      .optionalFromNullable(impl.forecastType())
      .map(value => zio.aws.forecast.model.primitives.ForecastType(value))
    override val wape: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.wape())
      .map(value => value: Double)
    override val rmse: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.rmse())
      .map(value => value: Double)
    override val mase: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.mase())
      .map(value => value: Double)
    override val mape: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.mape())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ErrorMetric
  ): zio.aws.forecast.model.ErrorMetric.ReadOnly = new Wrapper(impl)
}
