package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.{Status, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExplainabilityInfo(
    explainabilityArn: Optional[Arn] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.ExplainabilityInfo = {
    import ExplainabilityInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.ExplainabilityInfo
      .builder()
      .optionallyWith(
        explainabilityArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.explainabilityArn)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.ExplainabilityInfo.ReadOnly =
    zio.aws.forecast.model.ExplainabilityInfo.wrap(buildAwsValue())
}
object ExplainabilityInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.ExplainabilityInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.ExplainabilityInfo =
      zio.aws.forecast.model.ExplainabilityInfo(
        explainabilityArn.map(value => value),
        status.map(value => value)
      )
    def explainabilityArn: Optional[Arn]
    def status: Optional[Status]
    def getExplainabilityArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("explainabilityArn", explainabilityArn)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilityInfo
  ) extends zio.aws.forecast.model.ExplainabilityInfo.ReadOnly {
    override val explainabilityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.explainabilityArn())
      .map(value => zio.aws.forecast.model.primitives.Arn(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.forecast.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.ExplainabilityInfo
  ): zio.aws.forecast.model.ExplainabilityInfo.ReadOnly = new Wrapper(impl)
}
