package zio.aws.forecast.model
import zio.ZIO
import zio.aws.forecast.model.primitives.Name
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Featurization(
    attributeName: Name,
    featurizationPipeline: Optional[
      Iterable[zio.aws.forecast.model.FeaturizationMethod]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.Featurization = {
    import Featurization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.Featurization
      .builder()
      .attributeName(Name.unwrap(attributeName): java.lang.String)
      .optionallyWith(
        featurizationPipeline.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featurizationPipeline)
      .build()
  }
  def asReadOnly: zio.aws.forecast.model.Featurization.ReadOnly =
    zio.aws.forecast.model.Featurization.wrap(buildAwsValue())
}
object Featurization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.Featurization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.Featurization =
      zio.aws.forecast.model.Featurization(
        attributeName,
        featurizationPipeline.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attributeName: Name
    def featurizationPipeline
        : Optional[List[zio.aws.forecast.model.FeaturizationMethod.ReadOnly]]
    def getAttributeName: ZIO[Any, Nothing, Name] = ZIO.succeed(attributeName)
    def getFeaturizationPipeline: ZIO[Any, AwsError, List[
      zio.aws.forecast.model.FeaturizationMethod.ReadOnly
    ]] =
      AwsError.unwrapOptionField("featurizationPipeline", featurizationPipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.Featurization
  ) extends zio.aws.forecast.model.Featurization.ReadOnly {
    override val attributeName: Name =
      zio.aws.forecast.model.primitives.Name(impl.attributeName())
    override val featurizationPipeline
        : Optional[List[zio.aws.forecast.model.FeaturizationMethod.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featurizationPipeline())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.forecast.model.FeaturizationMethod.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.Featurization
  ): zio.aws.forecast.model.Featurization.ReadOnly = new Wrapper(impl)
}
