package zio.aws.forecast.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HyperParameterTuningJobConfig(
    parameterRanges: Optional[zio.aws.forecast.model.ParameterRanges] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig = {
    import HyperParameterTuningJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig
      .builder()
      .optionallyWith(parameterRanges.map(value => value.buildAwsValue()))(
        _.parameterRanges
      )
      .build()
  }
  def asReadOnly
      : zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly =
    zio.aws.forecast.model.HyperParameterTuningJobConfig.wrap(buildAwsValue())
}
object HyperParameterTuningJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.forecast.model.HyperParameterTuningJobConfig =
      zio.aws.forecast.model.HyperParameterTuningJobConfig(
        parameterRanges.map(value => value.asEditable)
      )
    def parameterRanges
        : Optional[zio.aws.forecast.model.ParameterRanges.ReadOnly]
    def getParameterRanges
        : ZIO[Any, AwsError, zio.aws.forecast.model.ParameterRanges.ReadOnly] =
      AwsError.unwrapOptionField("parameterRanges", parameterRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig
  ) extends zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly {
    override val parameterRanges
        : Optional[zio.aws.forecast.model.ParameterRanges.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterRanges())
        .map(value => zio.aws.forecast.model.ParameterRanges.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.forecast.model.HyperParameterTuningJobConfig
  ): zio.aws.forecast.model.HyperParameterTuningJobConfig.ReadOnly =
    new Wrapper(impl)
}
